#include "CPartEmmit.h"
#include "CApplication.h"



CPartEmmit::CPartEmmit()
{
    tm=reTm=1000.0;
    act=false;
    idP=0;
    life=100;
}

bool CPartEmmit::predict(float elapsedTime)
{
    if(tm<=elapsedTime)return true;
    return false;
}

void CPartEmmit::frameMove(float elapsedTime)
{
    if(act)
    {
        tm-=elapsedTime;
        if(tm<=0.0)
        {
            tm+=reTm;
            CApplication::selfPointer->mdp.addParticule(idP,pos.x,pos.y,pos.z,vel.x,vel.y,vel.z,life);
        }
    }
}

void CPartEmmit::setReTm(float reTm){tm=(this->reTm)=reTm;}
void CPartEmmit::start(){act=true;tm=(this->reTm);}
void CPartEmmit::stop(){act=false;}
void CPartEmmit::setIdP(unsigned char idP){this->idP=idP;}
void CPartEmmit::setLife(unsigned int life){this->life=life;}



CPartEmmitDisp::CPartEmmitDisp()
:CPartEmmit()
{
}

void CPartEmmitDisp::frameMove(float elapsedTime)
{
    if(act)
    {
        tm-=elapsedTime;
        if(tm<=0.0)
        {
            float fx,fy;
            fx=((((float)rand())/RAND_MAX)*2.0-1.0);
            fy=((((float)rand())/RAND_MAX)*2.0-1.0);
            tm+=reTm;
            CApplication::selfPointer->mdp.addParticule(idP,pos.x,pos.y,pos.z,
            vel.x+vX.x*fx+vY.x*fy,
            vel.y+vX.y*fx+vY.y*fy,
            vel.z+vX.z*fx+vY.z*fy,
            life);
            srand((time_t) rand());
        }
    }
}
